<?php
// -------------------------
// CORS: allow ALL origins (no credentials)
// -------------------------
header('Vary: Origin, Access-Control-Request-Method, Access-Control-Request-Headers');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Max-Age: 3600');

// Handle OPTIONS preflight EARLY and EXIT (no DB work)
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// From here on, normal API response is JSON
header('Content-Type: application/json; charset=UTF-8');

// -------------------------
// DB connection (use env vars in production)
// -------------------------
$host = "localhost";
$dbname = "dataquelayatiwor_enquiry";
$username = "dataquelayatiwor_user";
$password = "iG8+@XNx*F{O"; // ⚠️ rotate & move to env variables

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "DB connection failed"]);
    exit;
}

// -------------------------
// Read input (JSON or GET)
// -------------------------
$raw = file_get_contents('php://input');
$data = [];
if ($raw !== '' && $raw !== false) {
    $decoded = json_decode($raw, true);
    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
        $data = $decoded;
    }
}
if (!$data) {
    $data = $_GET; // fallback for simple GET
}

// Extract + basic sanitization
$fullName = trim($data['fullName'] ?? '');
$email    = trim($data['email'] ?? '');
$phone    = trim($data['phone'] ?? '');
$company  = trim($data['company'] ?? '');
$notes    = trim($data['notes'] ?? '');

// Validation
if ($fullName === '' || $email === '') {
    http_response_code(422);
    echo json_encode(["status" => "error", "message" => "Full Name & Email are required"]);
    exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(422);
    echo json_encode(["status" => "error", "message" => "Invalid email"]);
    exit;
}

// Insert
try {
    // $stmt = $pdo->prepare(
    //     "INSERT INTO certified_form (full_name, email, phone, company, notes)
    //      VALUES (:fullName, :email, :phone, :company, :notes)"
    // );
    // $stmt->execute([
    //     ':fullName' => $fullName,
    //     ':email'    => $email,
    //     ':phone'    => $phone,
    //     ':company'  => $company,
    //     ':notes'    => $notes,
    // ]);

    // -------------------------
    // SEND EMAIL
    // -------------------------
    $to = "Inbound@dataquel.com"; // 🔔 Change this to your destination email
    $subject = "New Enquiry from $fullName";
    $message = "
    You have received a new enquiry:

    Name: $fullName
    Email: $email
    Phone: $phone
    Company: $company
    Notes: $notes

    -------------------------
    Sent from Dataquel Enquiry Form
    ";
    $headers = "From: info@ayatiworks.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Suppress warnings if mail() fails, but you may log them
    @mail($to, $subject, $message, $headers);

    echo json_encode([
        "status"  => "success",
        "message" => "Enquiry saved successfully. Our team will get back to you shortly."
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Insert failed"]);
}
